//
//  ColorPicker.swift
//  Do It
//
//  Created by Jim Dovey on 2/4/20.
//  Copyright © 2020 Jim Dovey. All rights reserved.
//

import SwiftUI

fileprivate struct ColorButtonStyle: ButtonStyle {
    func makeBody(configuration: Configuration) -> some View {
        configuration.label
            .clipShape(Circle())
            .overlay(Circle().stroke().foregroundColor(.white))
            .doubleShadow(radius: configuration.isPressed ? 1 : 6)
    }
}

struct ColorPicker<Value: ColorInfo>: View {
    @Binding var selectedColor: Value
    var showSelectionBar: Bool = false
    
    var body: some View {
        VStack(spacing: 16) {
            ColorWheel(color: $selectedColor)

            HStack {
                ForEach(Value.predefined) { color in
                    Button(action: { self.selectedColor = color }) {
                        color.uiColor
                    }
                    .accessibility(label: Text(color.name))
                }
                .frame(maxHeight: 40)
            }
            .buttonStyle(ColorButtonStyle())

            if showSelectionBar {
                Rectangle()
                    .foregroundColor(selectedColor.uiColor)
                    .border(Color.white)
                    .doubleShadow(radius: 6)
                    .padding()
                    .frame(maxWidth: 200, maxHeight: 60)
            }
        }
    }
}

struct ColorPicker_Previews: PreviewProvider {
    static var previews: some View {
        StatefulPreviewWrapper(ListColor.blue) {
            ColorPicker(selectedColor: $0, showSelectionBar: true)
        }
    }
}
